﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace ct.Asteroid
{
    /// <summary>
    /// Asteroids 1.0 ... Markus Winklbauer ... 29.6.2008
    /// </summary>
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]

        static void Main()
        {
            if (Console.WindowWidth > 117) Console.WindowWidth = 117; Console.BufferWidth = 117;
            if (Console.WindowHeight > 51) Console.WindowHeight = 51; Console.BufferHeight = 51;

            if (Console.LargestWindowWidth >= Console.BufferWidth) { Console.WindowWidth = Console.BufferWidth; } else { Console.WindowWidth = Console.LargestWindowWidth; }
            if (Console.LargestWindowHeight >= Console.BufferHeight) { Console.WindowHeight = Console.BufferHeight; } else { Console.WindowHeight = Console.LargestWindowHeight; }
  
            Console.Clear();
            Console.CursorVisible = false;
            Console.Title = "Asteroids V1.0 (Markus Winklbauer)";

            String[] args = Environment.GetCommandLineArgs();
            IPAddress server_ip;

            if (args.Length != 2)
            {
               // server_ip = IPAddress.Parse("192.168.1.5");
               // server_ip = IPAddress.Parse("193.99.145.178");
               server_ip = IPAddress.Parse("127.0.0.1");
            }
            else
            {
                server_ip = IPAddress.Parse(args[1]);
                Console.WriteLine(" IP-Adresse: " + server_ip.ToString());
            }

            if (server_ip == null)
            {
                Console.WriteLine(" Ungueltige IP-Adresse: '" +args[1] + "'\n");
                Environment.Exit(1);
            }

            EndPoint myLocalEndpoint = new IPEndPoint(IPAddress.Any, 0);

            Socket sd = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);

            sd.ReceiveBufferSize = 2048;
            sd.Blocking = false;
            sd.Bind(myLocalEndpoint);

            Player player = new Player(sd, server_ip);

            if (1 == 1)
            {
                ThreadStart startDelegate1 = new ThreadStart(player.Run);
                Thread threadOne = new Thread(startDelegate1); threadOne.Name = "ThreadOne";
                threadOne.Priority = ThreadPriority.Highest;
                threadOne.Start();
            }
            else
            {
                player.Run();
            }
        }
    }
}
